
double  polyagama(z)
double  z;
{
  int     n, count; 
  long    idum1, idum2;
  double  t, K, p, q;
  double  U, V, U1;
  double  E, E1, a;
  
  double  pigauss();
  double  funterm();
  double  texpon();

  int     INDEX, FALSE, FALSE1;
  double  X,Y,S,W;
  double  mu, lbd, alpha;

  z = fabs(z)/2.0; 
  t = 0.640;
  K = 0.125*_PI*_PI+0.5* SQR(z);

  p = _PI*exp(-1.000*K*t)/(2.0*K);
  mu=1.0/z;  
  lbd=1.00;
  q = 2.0*exp(-1.00*z)*pigauss(t,mu,lbd);
  
  INDEX=0;  count=0;
  while ( INDEX == 0 ) {

          idum1=rand(); U=ran3(&idum1);
		 
          //////////// Generating J*(1,z/2) /////////
          
		  if  ( U < p/(p+q) ) {
			    idum1=rand(); E=expdev(&idum1);
                X=t+E/K;  
		  }
		  else{
                mu=1.00/z;
                if (  mu > t ) {
					  do{
					          idum1=rand(); E  = expdev(&idum1); 
					          idum2=rand(); E1 = expdev(&idum2);
						      while ( E*E > 2.0*E1/t) {
                                      idum1=rand(); E  = expdev(&idum1); 
								      idum2=rand(); E1 = expdev(&idum2);
							  }
                              X = 1.0+t*E;
							  X = t/(X*X);
                              alpha=exp(-0.5*z*z*X);
                              idum1=rand(); U1=ran3(&idum1);
					  } while ( U1 > alpha ); 
				}
                else{
					    do{
                               idum1=rand(); a=gasdev(&idum1);
                               Y = a*a;
                               X = mu+0.5*SQR(mu)*Y-0.5*mu*sqrt( 4.0*mu*Y+SQR(mu*Y) );
                               idum1=rand(); U1=ran3(&idum1);
                               if ( U1 > mu/(mu+X) )
                                    X=mu*mu/X;                           
						} while ( X > t) ; 
				} 
		  }
          /*///////////////////////////////////////*/
		  idum2=rand(); V=ran3(&idum2);
          n=0; S=funterm(n,t,X);  Y=V*S;
		   
          FALSE=0;
		  while ( FALSE == 0 ) {
                  n=n+1;
				  if ( n % 2 == 1 ) {
                       S=S-funterm(n,t,X);
                       if ( Y <= S ) {
                            W = 0.25 * X; 
							INDEX=1;
			                break;
					   }
				  }
                  else{
                       S=S+funterm(n,t,X);
                       if ( Y > S ) break; 
				  }
		  }
		  count+=1;
		  if (count > 1.0e8 )
			  nrerror(" Too iteration in routine POLYGAMA\n");
  }
  return(W);
}/*//////////////////////////////////*/

double  texpon(double Z)
{
  double t = 0.64;

  double fz = 0.125 * _PI*_PI + 0.5 * Z*Z;
  double b = sqrt(1.0 / t) * (t * Z - 1);
  double a = sqrt(1.0 / t) * (t * Z + 1) * -1.0;

  double x0 = log(fz) + fz * t;
  double xb = x0 - Z + PHI(b, 1);
  double xa = x0 + Z + PHI(a, 1);

  double qdivp = 4 / _PI * ( exp(xb) + exp(xa) );

  return 1.0 / (1.0 + qdivp);
}


double  pigauss(x,mu,lambda)
double  x;
double  mu, lambda;
{
  double  a, b, u, v;
  double  w;

  a = sqrt(lambda/x);
  b = x/mu;

  u = PHI(a*(b-1.0));
  v = PHI(-1.00*a*(b+1.0));
  w = u+exp(2.0*lambda/mu)*v;

  return (w);
} /*//// end of pigauss /////*/


double funterm(n,t,x)

int     n;
double  t, x;
{
	 double  f,K,h;
	 double  lgan;
     double  y;

	 f=(float)n+0.5;
     K=f*_PI;
	 
     if ( x > 0.0 && x <= t )
          lgan=-2.0*f*f/x - 1.50*( log(0.5*_PI) + log(x)) + log(K);
     else
          lgan=-0.5*K*K*x + log(K);

     y=exp(lgan);

     return (y);
}/*/// end of funterm ///// Copyrights (C). by Song, X. Y. (2005) ///*/ 

 